# 9장. 스케줄링: 비례 배분

**비례 배분(Proportional Share)** 스케줄러, 혹은 **공정 배분(fair share)** 이라고도 하는 유형의 스케줄러에 대해 다루어 보자.

### 반환 시간이나 응답 시간을 최적화하는 대신 스케줄러가 각 작업에게 CPU의 일정 비율을 보장하는 것이 목적인 스케줄러 (추첨 스케줄링 - lottery scheduling)

---

## 기본 개념: 추첨권이 당신의 몫을 나타낸다

- 추첨권(티켓)
    - 프로세스가 받아야 할 자원의 몫
    - 프로세스가 소유한 티켓의 개수와 전체 티켓에 대한 비율이 자신의 몫을 나타낸다.

추첨 스케줄링은 이러한 목적을 확률적으로(하지만 결정적이지는 않게) 달성한다.

---

## 추첨 기법

- 추첨권 화폐(ticket currency)
    - 사용자가 추첨권을 자신의 화폐 가치로 자유롭게 할당할 수 있도록 허용한다.
    - 시스템은 자동적으로 화폐 가치를 변환한다.
- 추첨권 양도(ticket transfer)
    - 프로세스는 일시적으로 추첨권을 다른 프로세스에게 넘겨줄 수 있다.
    - 이 기능은 클라이언트-서버 환경에서 특히 유용하다.
- 추첨권 팽창(ticket inflation)
    - 프로세스는 일시적으로 자신이 소유한 추첨권의 수를 늘리거나 줄일 수 있다.
    - 서로 신뢰하지 않는 프로세스들이 상호 경쟁하는 시나리오에서는 의미가 없다.

---

## 왜 결정론적(Deterministic) 방법을 사용하지 않는가

무작위성을 이용하면 스케줄러를 단순하게(그러나 어느 정도 정확하게) 만들 수 있지만, 정확한 비율을 보장할 수 없다. 짧은 기간만 실행되는 경우는 더 그렇다.

이 때문에 결정론적 공정 배분 스케줄러인 **보폭 스케줄링(stride scheduling)** 이 고안되었다.

추첨 스케줄링은 보폭 스케줄링과는 달리 상태 정보가 필요없다는 점이 유리하다.

새 프로세스를 추가할 때 보폭 스케줄링은 여러가지 상태 정보가 필요하지만, 추첨 스케줄링은 추첨권의 개수, 전체 추첨권의 개수만 갱신하면 되기 때문에 새로운 프로세스를 쉽게 추가할 수 있다.